<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pembayarans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('transaksi_id')->constrained(
                table: 'transaksis',
                indexName: 'pembayaran_transaksi_id'
            )->onDelete('cascade');
            $table->foreignId('bank_id')->constrained(
                table: 'moduls',
                indexName: 'pembayaran_bank_id'
            )->onDelete('cascade');
            $table->enum('sts_transfer', ['Y', 'N', 'T']);
            $table->dateTime('expired')->nullable();
            $table->dateTime('tgl_bayar')->nullable();
            $table->dateTime('tgl_diterima')->nullable();
            $table->text('struk');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pembayarans');
    }
};
